/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class Font {
    public static int[][] font = new int[256][8];

    public static int getByte(int c, int yOffset) {
        return font[c][yOffset];
    }

    private Font() {
    }

    static {
        try {
            InputStream in = ClassLoader.getSystemResourceAsStream("jace/data/font.gif");
            BufferedImage fontImage = ImageIO.read(in);
            for (int i = 0; i < 256; ++i) {
                int x = (i >> 4) * 13 + 2;
                int y = (i & 0xF) * 13 + 4;
                for (int j = 0; j < 8; ++j) {
                    int row = 0;
                    for (int k = 0; k < 7; ++k) {
                        int color = fontImage.getRGB(7 - k + x, j + y);
                        row = row << 1 | 1 - (color & 1);
                    }
                    Font.font[i][j] = row;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

